' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class Downloads
  Inherits System.Web.UI.Page

  Protected Sub lstCategoryLevel1_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstCategoryLevel1.SelectedIndexChanged
    lstCategoryLevel2.Visible = True
    lstCategoryLevel3.Visible = False
    ' Powi odsDownloads z t list rozwijan.
    Dim myParam As ControlParameter = CType(odsDownloads.SelectParameters(0), ControlParameter)
    myParam.ControlID = "lstCategoryLevel1"

    If lstCategoryLevel1.SelectedValue = "" Then
      lstCategoryLevel2.Visible = False
    End If
  End Sub

  Protected Sub lstCategoryLevel2_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstCategoryLevel2.SelectedIndexChanged
    If Not lstCategoryLevel2.SelectedValue = "" Then
      ' Uaktywnij trzeci list rozwijan
      lstCategoryLevel3.Visible = True
      ' Nastpnie powi odsDownloads z t list rozwijan.
      Dim myParam As ControlParameter = CType(odsDownloads.SelectParameters(0), ControlParameter)
      myParam.ControlID = "lstCategoryLevel2"
      lstCategoryLevel3.DataBind()
    Else
      Dim myParam As ControlParameter = CType(odsDownloads.SelectParameters(0), ControlParameter)
      myParam.ControlID = "lstCategoryLevel1"
      lstCategoryLevel3.Visible = False
    End If
  End Sub

  Protected Sub lstCategoryLevel3_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstCategoryLevel3.SelectedIndexChanged
    ' Powi odsDownloads z t list rozwijan jeli dokonano wyboru
    Dim myParam As ControlParameter = CType(odsDownloads.SelectParameters(0), ControlParameter)

    If Not lstCategoryLevel3.SelectedValue = "" Then
      myParam.ControlID = "lstCategoryLevel3"
    Else
      myParam.ControlID = "lstCategoryLevel2"
    End If
  End Sub

  Protected Sub lstCategoryLevel2_DataBound(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstCategoryLevel2.DataBound
    lstCategoryLevel2.Items.Insert(0, New ListItem("Brak", ""))
  End Sub

  Protected Sub lstCategoryLevel3_DataBound(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstCategoryLevel3.DataBound
    lstCategoryLevel3.Items.Insert(0, New ListItem("Brak", ""))
  End Sub

  Protected Sub odsDownloads_Selected(ByVal sender As Object, _
     ByVal e As System.Web.UI.WebControls.ObjectDataSourceStatusEventArgs) Handles _
        odsDownloads.Selected
    Dim recordsAffected As Integer = _
       Convert.ToInt32(e.OutputParameters.Item("recordsAffected"))

    Dim categoryName As String
    If lstCategoryLevel3.SelectedIndex > 0 Then
      categoryName = lstCategoryLevel3.SelectedItem.Text
    ElseIf lstCategoryLevel2.SelectedIndex > 0 Then
      categoryName = lstCategoryLevel2.SelectedItem.Text
    Else
      categoryName = lstCategoryLevel1.SelectedItem.Text
    End If
    If recordsAffected > 0 Then
      lblAffectedRows.Text = "Znalelimy " & recordsAffected & " dokument(w) w kategorii """ & categoryName & """."
    Else
      If lstCategoryLevel1.SelectedIndex > 0 Then
        lblAffectedRows.Text = "Nie znalelimy dokumentw w kategorii """ & categoryName & """."
      Else
        lblAffectedRows.Visible = False
      End If
    End If
  End Sub
End Class
